<?php
/**
 * Plugin Name: Anna Favicon Plus
 * Plugin URI:  https://beginnerplugins.com
 * Description: A simple tool to upload and manage favicons.
 * Version:     1.1
 * Author:      Anna Nicole kučerová  See also: <a href="https://nicoledigital.cz" target="_blank">NicoleDigital Network</a>
 */


defined('ABSPATH') or die('No script kiddies please!');

// Add Admin Menu
function afp_add_admin_menu() {
    add_menu_page('Anna Favicon Plus', 'AnnaFavicon', 'manage_options', 'afp_admin', 'afp_admin_page', 'dashicons-admin-appearance', 20);
}
add_action('admin_menu', 'afp_add_admin_menu');

// Admin Page Content
function afp_admin_page() {
    $favicon_url = get_option('afp_favicon') ? esc_url(get_option('afp_favicon')) : '';
    ?>
    <div class="wrap">
        <h1 style="background-color: blue; color: white; padding: 10px;">Easy Favicon Maker</h1>
        <p>Upload your favicon (**ICO format only**). Recommended size: <strong>64x64 pixels</strong>.</p>
        <form method="post" enctype="multipart/form-data">
            <label for="favicon_ico">Upload ICO file:</label>
            <input type="file" name="favicon_ico" accept=".ico"><br><br>
            <input type="submit" name="afp_submit" value="Save Favicon">
        </form>

        <?php if ($favicon_url): ?>
            <h2>Favicon Preview:</h2>
            <img src="<?php echo $favicon_url; ?>" width="64" height="64">
        <?php endif; ?>

        <h2>How to Use:</h2>
        <p>Simply upload a `.ico` file, and it will be applied as your site’s favicon automatically.</p>
        <p><strong>Need to convert a JPG to ICO?</strong> Use this free tool: <a href="https://www.favicon.io" target="_blank">favicon.io</a></p>
    </div>
    <?php
}

// Handle File Upload
function afp_handle_upload() {
    if (isset($_POST['afp_submit'])) {
        $uploads_dir = wp_upload_dir()['basedir'] . '/anna_favicon';
        if (!is_dir($uploads_dir)) mkdir($uploads_dir, 0755, true);

        $file = $_FILES['favicon_ico'];
        if ($file['error'] === UPLOAD_ERR_OK) {
            $file_name = basename($file['name']);
            $file_path = $uploads_dir . '/' . $file_name;
            move_uploaded_file($file['tmp_name'], $file_path);
            update_option('afp_favicon', wp_upload_dir()['baseurl'] . "/anna_favicon/" . $file_name);
        }
    }
}
add_action('admin_init', 'afp_handle_upload');

// Add Favicon to Site
function afp_add_favicon() {
    $favicon = get_option('afp_favicon');
    if ($favicon) {
        echo '<link rel="shortcut icon" href="' . esc_url($favicon) . '" type="image/x-icon">';
    }
}
add_action('wp_head', 'afp_add_favicon');
